@echo off
REM ---------------------------------------------------------------------------
REM
REM  Copyright (C) Intel Corporation, 2003 - 2006.
REM
REM  File:      rootCA_gen.bat
REM
REM  Contents:  batch file which creates a demo root CA certificate. 
REM
REM ----------------------------------------------------------------------------

REM ######################################################################
REM ###                                                                ###
REM ### This batch may be called by the Configuration Server program    ###
REM ### in order to generate a demo root CA certificate                ###
REM ### Normally, you won't need this batch, since you should be using ###
REM ### Your corporate CA.                                             ###
REM ### you may customize this script and modify the defaults          ###
REM ### at your own risk.                                              ###
REM ###                                                                ###
REM ######################################################################

setlocal

set PATH= %PATH%;../openSSl
set CATOP=.\rootCA
set SSLEAY_CONFIG=-config ../secConfig/rootCA.cfg
set CAKEY=.\cakey.pem
set CACERT=.\cacert.pem
set DAYS=-days 365

rmdir /q /s %CATOP%

mkdir %CATOP%
mkdir %CATOP%\certs 
mkdir %CATOP%\crl 
mkdir %CATOP%\newcerts
mkdir %CATOP%\private
echo 01 > %CATOP%\serial
copy nul %CATOP%\index.txt


openssl req %SSLEAY_CONFIG% -new -x509 -keyout %CATOP%\private\%CAKEY% -out %CATOP%\%CACERT% %DAYS%


copy /y %CATOP%\%CACERT% %CATOP%\cacert.cer


endlocal

IF NOT %CALLER_WAITS_ON_EXIT%=="" EXIT




